# Supplementary Material for the Paper: Assignment Problems in Cost Function Networks

This README provides an overview of the structure, commands, source directories, and benchmarks included in the supplementary material.
## Commands
To read the results and create cactus plots, simply run:
* python ReadRes.py

## Sources

This section describes the different source code repositories or directories used in this project.

* `toulbar2_LAPJV/`: Contains the sources for the Toulbar2 solver with LAPJV (Linear Assignment Problem via the Jonker-Volgenant algorithm) integration. Implementation is in core/tb2alldifferent.hpp and core/tb2gcc.hpp. Code from github: git clone --single-branch -b lapjv https://github.com/toulbar2/toulbar2.git
* `toulbar2_master/`:Contains the default master branch of the Toulbar2 solver, including features such as knapsack, all-different, flow propagators, and more.

## Benchmarks

This section outlines the benchmark instances and their corresponding result directories.

* `qapliboriginal/`: Stores results related to the original model of Quadratic Assignment Problem (QAPLIB) benchmarks.
* `qaplibnew/`: Stores results related to the new (inverted) model of Quadratic Assignment Problem (QAPLIB) benchmarks.


## toulbar2 and pytoulbar2 compilation

* Required packages for the pytoulbar2 library:
`sudo apt install pybind11-dev`
`pip install pybind11`
`pip install openpyxl`

* LAPJV release

mkdir -p toulbar2_LAPJV/toulbar2/build ; 

cd toulbar2_LAPJV/toulbar2/build

*clean:
rm -rf Testing CMakeFiles/ pytoulbar2/ Makefile compile_commands.json *.cmake toulbar2.1 validation.txz cover.txz DartConfiguration.tcl CMakeCache.txt 
rm toulbar2.1 validation.txz cover.txz 


#compilation pytoublar2 and toulbar2
cmake .. -DPYTB2=0N
make -j4
~               



# master release :

mkdir -p toulbar2_master/toulbar2/build ; 

cd toulbar2_master/toulbar2/build

#compilation pytoublar2 and toulbar2
cmake .. -DPYTB2=0N
make -j4

##Troubleshooting

* The pytoulbar2 model does not work

Ensure that pytoulbar2 is available in the model directory. You can either copy or create a symbolic link to pytoulbar2, or perform a global installation with:

make install

* The CPLEX model does not work with models containing more than 1000 variables

The Python module docplex is required with cplex academic or full commercial release.

You must install either the academic or commercial edition of IBM CPLEX. Ensure that your installed Python version is compatible with the CPLEX release.
For example, CPLEX 22.1.1 supports recent Python versions, including 3.10 and 3.11 on certain platforms.

Depending on your local Python installation, you may need to create a new isolated Python environment compatible with CPLEX. This can be done using tools such as:

    conda

    pip

    pipx

    uv
