#!/usr/bin/python
import os
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from openpyxl import Workbook


"""------------------QAPLIB NEW--------------------"""


Best={}
Bestknownssolutions = {}
with open("qaplibnew/best_knowns.txt", 'r') as f:
    lines = f.readlines()
    for line in lines:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        Bestknownssolutions[x] = y

directory = 'qaplibnew'
files = ["cplex", "ortools","sap","sncsapedac", "glbedacsap","sncglbsapedac", "lap","snclapedac", "glbedaclap","sncglblapedac"]
legend = ["CPLEX","CP-SAT", "SAP","SNC-SAP-Greedy", "SNC-SAP-GLB","SNC-SAP-GLB-Greedy", "LAP", "SNC-LAP-Greedy", "SNC-LAP-GLB","SNC-LAP-GLB-Greedy"]
optgap = {}
totalsol = []
tb2ilbgap = {}
avg_pretime = []
results = {}
nbfiles = len(files)
colors = plt.cm.tab10(range(len(legend)))
with open("qaplibnew/cplex/cplex.res", 'r') as f:
   
    lines = f.readlines()
    for line in lines[1:]:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        z = float(parts[2])
        op= parts[3]
        lb=parts[4]
        if op == "OPT":
            Best[x] = (y,True)
        else:
            Best[x] = (y,False)
        
def buildrestb2(file, initiallb_gap=False):       
    with open(file, 'r') as f:
        avgap = []
        pretime = 0.
        count = 0
        intial_lb_gap = []
        intial_lb_count = 0
        lines = f.readlines()
        restoulbar2 = {}
        for line in lines[1:]:
            parts = line.strip().split()
            x = parts[0]
            y = float(parts[1])
            if (initiallb_gap):
                intlb = float(parts[5])
                if (parts[6] == "UNK"):
                	print(x, file)
                pretime+=float(parts[6])
                if(Bestknownssolutions[x] > 0) : 
                	intial_lb_gap.append((intlb)/(Bestknownssolutions[x]))
                else :
                	intial_lb_gap.append(1)
                intial_lb_count+=1  
            if(y != -1 ):
            	if( Bestknownssolutions[x]>0):
                	avgap.append((y - Bestknownssolutions[x])/(y))
            	else :
                	avgap.append(0)
            	count+= 1
            z = float(parts[2])
            op= parts[3]
            lb=parts[4]
            if z < 1200:
                assert (op== "OPT")
            else:
                if(op != "FEAS" and op != "UNK"):
                    print(op, x, file)
                assert (op== "FEAS" or op== "UNK")
            if(y < Best[x][0] or Best[x][0] == -1):
                if op == "OPT":
                    Best[x] = (y,True)
                else:
                    Best[x] = (y,False)
            restoulbar2[x] = (y, z,op,lb)
   
    if (initiallb_gap):
        return [restoulbar2, np.array(avgap) * 100, (1 -np.array(intial_lb_gap)) * 100, pretime/intial_lb_count, count]
    else : 
       return [restoulbar2, np.array(avgap) * 100, count ]

plt.figure(figsize=(10, 6))



print("Create QAP_NEW_cactus.pdf")   

def compute_scores(results):
    """
    results[solver][instance] = (bound, time, status, lb)
    

    Returns:
        scores_per_instance[instance][solver] = score
        total_scores[solver] = sum of scores
    """

    # list solvers and instances
    solvers = list(results.keys())
    
    instances = set()
    for solver in results:
        instances.update(results[solver].keys())
    instances = sorted(instances)

    total_scores = {solver: 0.0 for solver in solvers}
    scores_per_instance = {}

    for inst in instances:
        instance_data = {}
        for solver in solvers:
            instance_data[solver] = results[solver].get(
                inst, (None, None, "UNK", None)
            )

       
        valid_bounds = [
            bound
            for (bound, time, status, lb) in instance_data.values()
            if status != "UNK" and bound != -1
        ]

        if not valid_bounds:
            scores_per_instance[inst] = {solver: 0.0 for solver in solvers}
            continue

        best_bound = min(valid_bounds)

        
        someone_proved_optimal = any(
            (bound == best_bound and status == "OPT")
            for (bound, time, status, lb) in instance_data.values()
        )

      
        inst_scores = {}

        for solver, (bound, time, status, lb) in instance_data.items():

         
            if status == "UNK" or bound == -1:
                inst_scores[solver] = 0.0
                continue

        
            if bound == best_bound and status == "OPT":
                inst_scores[solver] = 1.0

            # Case 2: best bound without optimality proof
            elif bound == best_bound:
                if someone_proved_optimal:
                    inst_scores[solver] = 0.5  # BB2
                else:
                    inst_scores[solver] = 1.0  # BB1

            # Case 3: worse bound
            else:
                inst_scores[solver] = 0.0

        scores_per_instance[inst] = inst_scores

        # accumulate totals
        for solver, score in inst_scores.items():
            total_scores[solver] += score

    return scores_per_instance, total_scores




i = -1
for file in files :
	i = i +1
	lbgap = i > 1
	if(lbgap) :
		path = directory +"/" +file + "/"+ file + ".res"
		timetoulbar2 = []
		out = buildrestb2(path, lbgap)
		restoulbar2 = out[0]
		results[legend[i]] = restoulbar2
		optgap[legend[i]] = out[1]
		tb2ilbgap[legend[i]] = out[2]

		for x in restoulbar2:
			if(restoulbar2[x][2] == "OPT"):
			    timetoulbar2.append(restoulbar2[x][1])

		times = sorted(timetoulbar2)  # Sort times in increasing order
		y = times              # Y-axis: runtimes
		x = range(1, len(times)+1)  # X-axis: number of instances solved
		if(i < 6) :
			plt.plot(x, y, marker='o',color = colors[i], label=f'{legend[i]} [{len(timetoulbar2)} solved]')
		else :
			plt.plot(x, y, linestyle="--" ,marker='+',  color= colors[i - 4], label=f'{legend[i]} [{len(timetoulbar2)} solved]')
    

plt.xlabel("Number of solved instances", fontsize=12)
plt.ylabel("CPU Time (seconds)", fontsize=12)
plt.legend(loc='upper left', fontsize=10)
plt.grid(True, linestyle='--', alpha=0.6)
plt.tight_layout()
plt.savefig("QAP_NEW_cactus.pdf")


def buildgapcsv(models, plot_name, results) :
	scores = compute_scores(results)[1]
	print("Create", plot_name)  
	data_list = []
	nbelts = []
	order = list(models.keys())
	for name, arr in models.items():
		data_list.append(pd.DataFrame({"Solver": name, "gap %": arr}))
		nbelts.append((arr.shape)[0])
	df = pd.concat(data_list, ignore_index=True)

	
	stats = df.groupby("Solver").agg(["mean", "median", "std"])["gap %"]
	for col in stats.select_dtypes(include=["float", "int"]):
        	stats[col] = stats[col].map(lambda x: f"{x:.2f}")
        	
	stats = stats.reindex(order)
	stats["Scores"] = scores
	stats["Instances"] = nbelts
	print(stats)
	file_name = plot_name + ".csv"
	latex_name = plot_name + ".tex"
	stats.to_csv(file_name, encoding="utf-8")
	latex_code = stats.to_latex(index=True, escape=True)

	with open(latex_name, "w") as f:
	    f.write(latex_code)
	

keys1 = ["SAP", "SNC-SAP-Greedy","SNC-SAP-GLB" ,"SNC-SAP-GLB-Greedy"]
keys2 = ["LAP", "SNC-LAP-Greedy", "SNC-LAP-GLB", "SNC-LAP-GLB-Greedy"]
suboptgap1  = {k: optgap[k] for k in keys1}
suboptgap2  = {k: optgap[k] for k in keys2}
subresults1  = {k: results[k] for k in keys1}
subresults2  = {k: results[k] for k in keys2}

buildgapcsv(suboptgap1, "QAP_NEW_SAP_OPTIMUM_GAP", subresults1)
buildgapcsv(suboptgap2, "QAP_NEW_LAP_OPTIMUM_GAP", subresults2)







"""------------------QAPLIB ORIGINAL--------------------"""

optgap = []
totalsol = []
nbfiles = len(files)
Best={}
optgap = {}
totalsol = []
tb2ilbgap = {}
nbfiles = len(files)
directory = 'qapliboriginal'
files = ["cplex", "ortools", "lap" ,"snclapedac","glbedaclap", "sncglblapedac"]
legend = ["CPLEX","CP-SAT","LAP","SNC-LAP-Greedy","SNC-LAP-GLB", "SNC-LAP-GLB-Greedy"]
results = {}
with open("qapliboriginal/cplex/cplex.res", 'r') as f:
    lines = f.readlines()
    for line in lines[1:]:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        z = float(parts[2])
        op= parts[3]
        lb=parts[4]
        if op == "OPT":
            Best[x] = (y,True)
        else:
            Best[x] = (y,False)
        

plt.figure(figsize=(10, 6))

print("Create QAP_ORIGINAL_cactus.pdf")   
i = -1
for file in files :
    i = i +1
    lbgap = i > 1
    path = directory +"/" +file + "/"+ file + ".res"
    timetoulbar2 = []
    out = buildrestb2(path, lbgap)
    restoulbar2 = out[0]
    optgap[legend[i]] = out[1]
    results[legend[i]] = restoulbar2
    if(lbgap) :
        tb2ilbgap[legend[i]] = out[2]

    
    for x in restoulbar2:
        if(restoulbar2[x][2] == "OPT"):
            timetoulbar2.append(restoulbar2[x][1])

    times = sorted(timetoulbar2)  # Sort times in increasing order
    y = times              # Y-axis: runtimes
    x = range(1, len(times)+1)  # X-axis: number of instances solved
    plt.plot(x, y, marker='o', label=f'{legend[i]} [{len(timetoulbar2)} solved]')
    

plt.xlabel("Number of solved instances", fontsize=12)
plt.ylabel("CPU Time (seconds)", fontsize=12)
plt.legend(loc='upper left', fontsize=10)
plt.grid(True, linestyle='--', alpha=0.6)
plt.tight_layout()
plt.savefig("QAP_ORIGINAL_cactus.pdf")

buildgapcsv(optgap, "QAP_ORIGINAL_OPTIMUM_GAP", results)


"""------------------SNC--------------------"""


Best={}
Bestknownssolutions = {}
with open("qaplibnew/best_knowns.txt", 'r') as f:
    lines = f.readlines()
    for line in lines:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        Bestknownssolutions[x] = y

directory = 'qaplibnew'
files = ["sncsapedac", "glbedacsap","sncglbsapedac", "snclapedac", "glbedaclap","sncglblapedac"]
legend = ["SNC-SAP-Greedy", "SNC-SAP-GLB", "SNC-SAP-GLB-Greedy","SNC-LAP-Greedy","SNC-LAP-GLB", "SNC-LAP-GLB-Greedy"]
optgap = {}
totalsol = []
tb2ilbgap = {}
avg_pretime = []
results = {}
nbfiles = len(files)
tb2sncit = {}
tb2snctime = {}
tb2pretime = {}
tb2lbcount = {}
colors = plt.cm.tab10(range(len(legend)))
with open("qaplibnew/cplex/cplex.res", 'r') as f:
   
    lines = f.readlines()
    for line in lines[1:]:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        z = float(parts[2])
        op= parts[3]
        lb=parts[4]
        if op == "OPT":
            Best[x] = (y,True)
        else:
            Best[x] = (y,False)
        
def buildrestb2(file):       
    with open(file, 'r') as f:
        avgap = []
        pretime = 0.
        count = 0
        intial_lb_gap = 0
        intial_lb_count = 0
        sncit = 0
        snctime = 0
        lines = f.readlines()
        restoulbar2 = {}
        for line in lines[1:]:
            parts = line.strip().split()
            x = parts[0]
            y = float(parts[1])
            if (True):
                intlb = float(parts[5])
                if (parts[6] == "UNK"):
                	print(x, file)
                pretime+=float(parts[6])
                if (parts[7] == 'UNK'):
                	print(x, file)
                sncit+=int(parts[7])
                snctime+=float(parts[8])
                if(Bestknownssolutions[x] > 0) : 
                	intial_lb_gap+= (1- (intlb/(Bestknownssolutions[x])))
                else :
                	intial_lb_gap+= 0
                intial_lb_count+=1  
            z = float(parts[2])
            op= parts[3]
            lb=parts[4]
            if z < 1200:
                assert (op== "OPT")
            else:
                if(op != "FEAS" and op != "UNK"):
                    print(op, x, file)
                assert (op== "FEAS" or op== "UNK")
            if(y < Best[x][0] or Best[x][0] == -1):
                if op == "OPT":
                    Best[x] = (y,True)
                else:
                    Best[x] = (y,False)
            restoulbar2[x] = (y, z,op,lb)
 
    return [restoulbar2,  (intial_lb_gap/intial_lb_count) * 100,  sncit/intial_lb_count, snctime/intial_lb_count, pretime/intial_lb_count, int(intial_lb_count)]
i = -1
initiallb_gap = True
for file in files :
	i = i +1
	path = directory +"/" +file + "/"+ file + ".res"
	timetoulbar2 = []
	out = buildrestb2(path)
	restoulbar2 = out[0]
	tb2ilbgap[legend[i]] = out[1]
	tb2sncit[legend[i]] = out[2]
	tb2snctime[legend[i]] = out[3]
	tb2pretime[legend[i]] = out[4]
	tb2lbcount[legend[i]] = out[5]
data = [tb2ilbgap, tb2sncit, tb2snctime, tb2lbcount]


df = pd.DataFrame(data)
df= df.T

df.columns = ["AvgInitialLbGap", "AvgSncIterations", "AvgSncTimes","NbInstances"]
df.index.name = "Preprocessing"
for col in df.select_dtypes(include=["float", "int"]):
	df[col] = df[col].map(lambda x: f"{x:.2f}")
print(df)	
df.to_csv("QAP_NEW_SNC_TIME.csv", encoding="utf-8")

"""------------------QAPLIB ORIGINAL--------------------"""

optgap = []
totalsol = []
nbfiles = len(files)
Best={}
optgap = {}
totalsol = []
tb2ilbgap = {}
tb2sncit = {}
tb2snctime = {}
tb2pretime = {}
tb2lbcount = {}
nbfiles = len(files)
directory = 'qapliboriginal'
files = ["snclapedac","glbedaclap", "sncglblapedac"]
legend = ["SNC+LAP+EDAC", "GLB+LAP+EDAC", "GLB+SNC+LAP+EDAC"]
results = {}
with open("qapliboriginal/cplex/cplex.res", 'r') as f:
    lines = f.readlines()
    for line in lines[1:]:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        z = float(parts[2])
        op= parts[3]
        lb=parts[4]
        if op == "OPT":
            Best[x] = (y,True)
        else:
            Best[x] = (y,False)
        

i = -1
initiallb_gap = True
for file in files :
	i = i +1
	path = directory +"/" +file + "/"+ file + ".res"
	timetoulbar2 = []
	out = buildrestb2(path)
	restoulbar2 = out[0]
	tb2ilbgap[legend[i]] = out[1]
	tb2sncit[legend[i]] = out[2]
	tb2snctime[legend[i]] = out[3]
	tb2pretime[legend[i]] = out[4]
	tb2lbcount[legend[i]] = out[5]
data = [tb2ilbgap, tb2sncit,tb2snctime]


df = pd.DataFrame(data)
df= df.T
df.columns = ["AvgInitialLbGap", "AvgSncIterations", "AvgSncTimes"]
for col in df.select_dtypes(include=["float", "int"]):
	df[col] = df[col].map(lambda x: f"{x:.2f}")
df.index.name = "Preprocessing"	
df.to_csv("QAP_ORIGINAL_SNC_TIME.csv", encoding="utf-8")
print(df)

"""------------------BEST MODEL--------------------"""


Best={}
Bestknownssolutions = {}

directorys = ["qaplibnew/sap","qaplibnew/sncsapedac", "qaplibnew/glbedacsap","qaplibnew/sncglbsapedac", "qapliboriginal/lap","qapliboriginal/snclapedac", "qapliboriginal/glbedaclap","qapliboriginal/sncglblapedac"]

files = ["sap","sncsapedac", "glbedacsap","sncglbsapedac", "lap","snclapedac", "glbedaclap","sncglblapedac"]
legend = ["SAP","SNC-SAP-Greedy", "SNC-SAP-GLB","SNC-SAP-GLB-Greedy", "LAP", "SNC-LAP-Greedy", "SNC-LAP-GLB","SNC-LAP-GLB-Greedy"]

with open("qaplibnew/best_knowns.txt", 'r') as f:
    lines = f.readlines()
    for line in lines:
        parts = line.strip().split()
        x = parts[0]
        y = float(parts[1])
        Bestknownssolutions[x] = y
        Best[x] = {"BestModel" : 0, "Ub" : 20000000000, "Time" : 2400, "Lb" : 0, "Status": "UNK"}

i = -1
for file in files :
	i = i +1
	path = directorys[i] + "/" + file + ".res"
	with open(path, 'r') as f:  
		lines = f.readlines()
		for line in lines[1:]:
			parts = line.strip().split()
			x = parts[0]
			y = float(parts[1])
			z = float(parts[2])
			lb =  float(parts[4])
			op = parts[3]
			if(op == "OPT") :
				if(z < Best[x]["Time"]):
					Best[x] = {"BestModel" : legend[i], "Ub" : y , "Time" : z, "Lb" : lb, "Status": op}
			if(op == "FEAS") :
				if(y < Best[x]["Ub"]):
					Best[x] = {"BestModel" : legend[i], "Ub" : y , "Time" : z, "Lb" : lb, "Status": op}

			if(Best[x]["Status"] == "UNK") :
				if(lb > Best[x]["Lb"]):
					Best[x] = {"BestModel" : legend[i], "Ub" : y , "Time" : z, "Lb" : lb, "Status": op}
     
df = pd.DataFrame(Best).T  
print(df)

df.index.name = "Instances"	


df.to_csv("QAP_TB2_BEST_MODEL.csv", encoding="utf-8")



"""------------------Toulbar2 Vs Branch-and-cut --------------------"""

df = pd.read_csv("QAP_TB2_VS_BAC.csv")
tb2only = df[df["Time_base"] == 216000]
baconly = df[df["Status"] == "FEAS"]
tb2andbac = df[(df["Status"] != "FEAS") & (df["Time_base"] != 216000)]
colors = plt.cm.tab10(range(4))
plt.figure(figsize=(10, 6))

plt.scatter(
    tb2only["Time_tb2"], tb2only["Time_base"],
    label=f"Toulbar2-only solved instances [{tb2only.shape[0]}]",
    color=colors[3]
)

plt.scatter(
    baconly["Time_tb2"], baconly["Time_base"],
    label=f"Branch-and-cut-only solved instances [{baconly.shape[0]}]",
    color=colors[2]
)

plt.scatter(
    tb2andbac["Time_tb2"], tb2andbac["Time_base"],
    label=f"Instances solved by both Toulbar2 and Branch-and-cut [{tb2andbac.shape[0]}]",
    color=colors[1]
)

min_val = min(df["Time_tb2"].min(), df["Time_base"].min())
max_val = max(df["Time_tb2"].max(), df["Time_base"].max())

diag = np.linspace(min_val, max_val, 100)
plt.plot(diag, diag, linestyle="--", label="Toulbar2 Time = Branch-and-Cut Time", color =colors[0])
plt.xscale("log")
plt.yscale("log")
plt.xlabel("Toulbar2 Time (log scale)", fontsize=12)
plt.ylabel("Branch-and-Cut Time (log scale)", fontsize=12)
plt.legend(loc='upper left', fontsize=10)
plt.grid(True, linestyle='--', alpha=0.6)
plt.tight_layout()

plt.savefig("QAP_TB2VSBAC.pdf")
